define(['angular', 'angularMocks', 'app', 'HeaderController', 'angularUiRouter', 'Modernizr'], function(angular, mocks, app) {
    'use strict';

    describe('The Header controller', function () {

        var controller,
            rootScope,
            scope,
            state,
            authenticationServiceMock;

        beforeEach( function () {
            module('angularTemplateApp');

            authenticationServiceMock = jasmine.createSpyObj('authenticationService', ['isAuthenticated']);
            authenticationServiceMock.isAuthenticated.andCallFake( function() {
                return true;
            });

            module(function($provide){
                $provide.value('authenticationService', authenticationServiceMock);
            });

            inject(function ($controller, $rootScope, $state) {
                rootScope = $rootScope;
                scope = rootScope.$new();
                state = $state;
                spyOn(scope, '$on').andCallThrough();
                controller = $controller('HeaderController', {$scope: scope, $state: state});
            });
        });

        it("should have a function to go home", function(){
            expect(scope.goHome).toBeDefined();
        });

        describe("when state changes", function(){
            describe("and user is unauthenticated", function(){
                beforeEach(function(){
                    authenticationServiceMock.isAuthenticated.andCallFake( function() {
                        return false;
                    });
                    state.current.name = 'main.splash';
                    scope.$root.$digest();
                    scope.$broadcast('$stateChangeSuccess', {name: 'main.splash'});
                });

                it("should not show the home button", function() {
                    expect(authenticationServiceMock.isAuthenticated).toHaveBeenCalled();
                    expect(scope.showHomeButton).toBe(false);
                });

                it("should have app name as scope.title", function() {
                    expect(scope.title).toBe('VA Tool Set');
                });

                it("should have app name as scope.headerTitle", function() {
                    expect(scope.headerTitle).toBe('VA Tool Set');
                });
            });

            describe("and user is authenticated on home page", function(){
                beforeEach(function(){
                    state.current.name = 'main.auth.home';
                    scope.$root.$digest();
                    scope.$broadcast('$stateChangeSuccess', {name: 'main.auth.home'});
                });

                it("should not show the home button", function() {
                    expect(authenticationServiceMock.isAuthenticated).toHaveBeenCalled();
                    expect(scope.showHomeButton).toBe(false);
                });

                it("should have app name as scope.title", function() {
                    expect(scope.title).toBe('VA Tool Set');
                });

                it("should have app name as scope.headerTitle", function() {
                    expect(scope.headerTitle).toBe('VA Tool Set');
                });
            });

            describe("to a two-panel layout with a module name", function(){

                beforeEach(function(){
                    state.current.name = 'main.auth.two-panel.secondary-navigation.var-utility';
                    state.current.data = {
                        moduleName: 'VAR Utility'
                    };
                    scope.$root.$digest();
                    scope.$broadcast('$stateChangeSuccess', {name: 'main.auth.two-panel.secondary-navigation.var-utility'});
                });

                it("should show the home button", function() {
                    expect(authenticationServiceMock.isAuthenticated).toHaveBeenCalled();
                    expect(scope.showHomeButton).toBe(true);
                });

                it("should have scope.title in format 'app name - module name'", function() {
                    expect(scope.title).toBe('VA Tool Set - VAR Utility');
                });

                it("should have scope.headerTitle in format 'app name - module name'", function() {
                    expect(scope.headerTitle).toBe('VA Tool Set - VAR Utility');
                });
            });

            describe("to a non two-panel layout with a module name", function(){

                beforeEach(function(){
                    state.current.name = 'main.auth.one-panel.assessment-builder';
                    state.current.data = {
                        moduleName: 'Assessment Builder'
                    };
                    scope.$root.$digest();
                    scope.$broadcast('$stateChangeSuccess', {name: 'main.auth.one-panel.assessment-builder'});
                });

                it("should show the home button", function() {
                    expect(authenticationServiceMock.isAuthenticated).toHaveBeenCalled();
                    expect(scope.showHomeButton).toBe(true);
                });

                it("should have app name as scope.title", function() {
                    expect(scope.title).toBe('VA Tool Set');
                });

                it("should have scope.headerTitle in format 'app name - module name'", function() {
                    expect(scope.headerTitle).toBe('VA Tool Set - Assessment Builder');
                });
            });
        });
    });
});